<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GrpController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/grplist[/{id}]", [PermissionMiddleware::class], "list.grp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrpList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/grpadd[/{id}]", [PermissionMiddleware::class], "add.grp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrpAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/grpview[/{id}]", [PermissionMiddleware::class], "view.grp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrpView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/grpedit[/{id}]", [PermissionMiddleware::class], "edit.grp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrpEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/grpsearch", [PermissionMiddleware::class], "search.grp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrpSearch");
    }
}
