<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GodownTransferTableController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/godowntransfertablelist[/{id}]", [PermissionMiddleware::class], "list.godown_transfer_table")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferTableList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/godowntransfertableadd[/{id}]", [PermissionMiddleware::class], "add.godown_transfer_table")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferTableAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/godowntransfertableview[/{id}]", [PermissionMiddleware::class], "view.godown_transfer_table")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferTableView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/godowntransfertablesearch", [PermissionMiddleware::class], "search.godown_transfer_table")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferTableSearch");
    }
}
