<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GodownTransferHsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/godowntransferhslist[/{id}]", [PermissionMiddleware::class], "list.godown_transfer_hs")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferHsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/godowntransferhsadd[/{id}]", [PermissionMiddleware::class], "add.godown_transfer_hs")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferHsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/godowntransferhsview[/{id}]", [PermissionMiddleware::class], "view.godown_transfer_hs")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferHsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/godowntransferhsedit[/{id}]", [PermissionMiddleware::class], "edit.godown_transfer_hs")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferHsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/godowntransferhsdelete[/{id}]", [PermissionMiddleware::class], "delete.godown_transfer_hs")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTransferHsDelete");
    }
}
