<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GodownTableController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/godowntablelist[/{id}]", [PermissionMiddleware::class], "list.godown_table")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTableList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/godowntableadd[/{id}]", [PermissionMiddleware::class], "add.godown_table")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTableAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/godowntableaddopt", [PermissionMiddleware::class], "addopt.godown_table")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTableAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/godowntableview[/{id}]", [PermissionMiddleware::class], "view.godown_table")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTableView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/godowntableedit[/{id}]", [PermissionMiddleware::class], "edit.godown_table")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTableEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/godowntabledelete[/{id}]", [PermissionMiddleware::class], "delete.godown_table")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownTableDelete");
    }
}
