<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GodownController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/godownlist[/{id}]", [PermissionMiddleware::class], "list.godown")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/godownadd[/{id}]", [PermissionMiddleware::class], "add.godown")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/godownview[/{id}]", [PermissionMiddleware::class], "view.godown")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GodownView");
    }
}
