<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GatePassReceivedController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/gatepassreceivedlist[/{gp_no}]", [PermissionMiddleware::class], "list.gate_pass_received")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GatePassReceivedList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/gatepassreceivedview[/{gp_no}]", [PermissionMiddleware::class], "view.gate_pass_received")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GatePassReceivedView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/gatepassreceivededit[/{gp_no}]", [PermissionMiddleware::class], "edit.gate_pass_received")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GatePassReceivedEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/gatepassreceivedsearch", [PermissionMiddleware::class], "search.gate_pass_received")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GatePassReceivedSearch");
    }
}
