<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GatePassController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/gatepasslist[/{gp_no}]", [PermissionMiddleware::class], "list.gate_pass")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GatePassList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/gatepassadd[/{gp_no}]", [PermissionMiddleware::class], "add.gate_pass")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GatePassAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/gatepassedit[/{gp_no}]", [PermissionMiddleware::class], "edit.gate_pass")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GatePassEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/gatepasssearch", [PermissionMiddleware::class], "search.gate_pass")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GatePassSearch");
    }
}
