<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GalleryMiscController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/gallerymisclist[/{id}]", [PermissionMiddleware::class], "list.gallery_misc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryMiscList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/gallerymiscadd[/{id}]", [PermissionMiddleware::class], "add.gallery_misc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryMiscAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/gallerymiscaddopt", [PermissionMiddleware::class], "addopt.gallery_misc")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryMiscAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/gallerymiscview[/{id}]", [PermissionMiddleware::class], "view.gallery_misc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryMiscView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/gallerymiscedit[/{id}]", [PermissionMiddleware::class], "edit.gallery_misc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryMiscEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/gallerymiscdelete[/{id}]", [PermissionMiddleware::class], "delete.gallery_misc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryMiscDelete");
    }
}
