<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class GalleryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/gallerylist[/{id}]", [PermissionMiddleware::class], "list.gallery")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/galleryadd[/{id}]", [PermissionMiddleware::class], "add.gallery")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/galleryview[/{id}]", [PermissionMiddleware::class], "view.gallery")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/galleryedit[/{id}]", [PermissionMiddleware::class], "edit.gallery")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/gallerydelete[/{id}]", [PermissionMiddleware::class], "delete.gallery")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GalleryDelete");
    }
}
