<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class FeSetupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/fesetuplist[/{id}]", [PermissionMiddleware::class], "list.fe_setup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FeSetupList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/fesetupview[/{id}]", [PermissionMiddleware::class], "view.fe_setup")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FeSetupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/fesetupedit[/{id}]", [PermissionMiddleware::class], "edit.fe_setup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FeSetupEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/fesetupdelete[/{id}]", [PermissionMiddleware::class], "delete.fe_setup")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FeSetupDelete");
    }
}
