<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class FamilyMiscController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/familymisclist[/{id}]", [PermissionMiddleware::class], "list.family_misc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyMiscList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/familymiscadd[/{id}]", [PermissionMiddleware::class], "add.family_misc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyMiscAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/familymiscaddopt", [PermissionMiddleware::class], "addopt.family_misc")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyMiscAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/familymiscview[/{id}]", [PermissionMiddleware::class], "view.family_misc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyMiscView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/familymiscedit[/{id}]", [PermissionMiddleware::class], "edit.family_misc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyMiscEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/familymiscdelete[/{id}]", [PermissionMiddleware::class], "delete.family_misc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyMiscDelete");
    }
}
