<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class FamilyInfoView2Controller extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/familyinfoview2list[/{id}]", [PermissionMiddleware::class], "list.family_info_view2")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoView2List");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/familyinfoview2add[/{id}]", [PermissionMiddleware::class], "add.family_info_view2")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoView2Add");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/familyinfoview2view[/{id}]", [PermissionMiddleware::class], "view.family_info_view2")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoView2View");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/familyinfoview2edit[/{id}]", [PermissionMiddleware::class], "edit.family_info_view2")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoView2Edit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/familyinfoview2update", [PermissionMiddleware::class], "update.family_info_view2")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoView2Update");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/familyinfoview2search", [PermissionMiddleware::class], "search.family_info_view2")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoView2Search");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/familyinfoview2query", [PermissionMiddleware::class], "query.family_info_view2")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoView2Search", "FamilyInfoView2Query");
    }
}
