<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class FamilyInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/familyinfolist[/{id}]", [PermissionMiddleware::class], "list.family_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/familyinfoadd[/{id}]", [PermissionMiddleware::class], "add.family_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/familyinfoview[/{id}]", [PermissionMiddleware::class], "view.family_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/familyinfoedit[/{id}]", [PermissionMiddleware::class], "edit.family_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/familyinfoupdate", [PermissionMiddleware::class], "update.family_info")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/familyinfosearch", [PermissionMiddleware::class], "search.family_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/familyinfoquery", [PermissionMiddleware::class], "query.family_info")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyInfoSearch", "FamilyInfoQuery");
    }
}
