<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class FamilyEventListController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/familyeventlistlist[/{id}]", [PermissionMiddleware::class], "list.family_event_list")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventListList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/familyeventlistadd[/{id}]", [PermissionMiddleware::class], "add.family_event_list")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventListAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/familyeventlistaddopt", [PermissionMiddleware::class], "addopt.family_event_list")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventListAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/familyeventlistview[/{id}]", [PermissionMiddleware::class], "view.family_event_list")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventListView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/familyeventlistedit[/{id}]", [PermissionMiddleware::class], "edit.family_event_list")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventListEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/familyeventlistdelete[/{id}]", [PermissionMiddleware::class], "delete.family_event_list")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventListDelete");
    }
}
