<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class FamilyEventEstimateController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/familyeventestimatelist[/{id}]", [PermissionMiddleware::class], "list.family_event_estimate")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventEstimateList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/familyeventestimateadd[/{id}]", [PermissionMiddleware::class], "add.family_event_estimate")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventEstimateAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/familyeventestimateview[/{id}]", [PermissionMiddleware::class], "view.family_event_estimate")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventEstimateView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/familyeventestimateedit[/{id}]", [PermissionMiddleware::class], "edit.family_event_estimate")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventEstimateEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/familyeventestimatedelete[/{id}]", [PermissionMiddleware::class], "delete.family_event_estimate")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventEstimateDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/familyeventestimatesearch", [PermissionMiddleware::class], "search.family_event_estimate")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventEstimateSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/familyeventestimatequery", [PermissionMiddleware::class], "query.family_event_estimate")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FamilyEventEstimateSearch", "FamilyEventEstimateQuery");
    }
}
