<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ExportlogController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/exportloglist[/{fileId:.*}]", [PermissionMiddleware::class], "list.exportlog")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ExportlogList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/exportlogadd[/{fileId:.*}]", [PermissionMiddleware::class], "add.exportlog")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ExportlogAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/exportlogview[/{fileId:.*}]", [PermissionMiddleware::class], "view.exportlog")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ExportlogView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/exportlogedit[/{fileId:.*}]", [PermissionMiddleware::class], "edit.exportlog")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ExportlogEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/exportlogdelete[/{fileId:.*}]", [PermissionMiddleware::class], "delete.exportlog")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ExportlogDelete");
    }
}
