<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class DownloadController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/downloadlist[/{id}]", [PermissionMiddleware::class], "list.download")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DownloadList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/downloadadd[/{id}]", [PermissionMiddleware::class], "add.download")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DownloadAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/downloadview[/{id}]", [PermissionMiddleware::class], "view.download")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DownloadView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/downloadedit[/{id}]", [PermissionMiddleware::class], "edit.download")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DownloadEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/downloaddelete[/{id}]", [PermissionMiddleware::class], "delete.download")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DownloadDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/downloadsearch", [PermissionMiddleware::class], "search.download")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DownloadSearch");
    }
}
