<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class DescriptionController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/descriptionlist[/{id}]", [PermissionMiddleware::class], "list.description")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DescriptionList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/descriptionadd[/{id}]", [PermissionMiddleware::class], "add.description")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DescriptionAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/descriptionview[/{id}]", [PermissionMiddleware::class], "view.description")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DescriptionView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/descriptionedit[/{id}]", [PermissionMiddleware::class], "edit.description")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DescriptionEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/descriptiondelete[/{id}]", [PermissionMiddleware::class], "delete.description")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DescriptionDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/descriptionsearch", [PermissionMiddleware::class], "search.description")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DescriptionSearch");
    }
}
