<?php

namespace PHPMaker2024\fibre;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

/**
 * Day_Planner controller
 */
class DayPlannerController extends ControllerBase
{
    // calendar
    #[Map(["GET", "POST", "OPTIONS"], "/dayplanner", [PermissionMiddleware::class], "calendar.Day_Planner")]
    public function calendar(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DayPlannerCalendar");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/dayplanneradd[/{id}]", [PermissionMiddleware::class], "add.Day_Planner")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DayPlannerAdd");
    }

    // view
    #[Map(["GET","OPTIONS"], "/dayplannerview[/{id}]", [PermissionMiddleware::class], "view.Day_Planner")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DayPlannerView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/dayplanneredit[/{id}]", [PermissionMiddleware::class], "edit.Day_Planner")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DayPlannerEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/dayplannerdelete[/{id}]", [PermissionMiddleware::class], "delete.Day_Planner")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DayPlannerDelete");
    }
}
