<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class Dashboard2Controller extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/dashboard2list[/{id}]", [PermissionMiddleware::class], "list.dashboard2")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Dashboard2List");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/dashboard2add[/{id}]", [PermissionMiddleware::class], "add.dashboard2")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Dashboard2Add");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/dashboard2view[/{id}]", [PermissionMiddleware::class], "view.dashboard2")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Dashboard2View");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/dashboard2edit[/{id}]", [PermissionMiddleware::class], "edit.dashboard2")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Dashboard2Edit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/dashboard2update", [PermissionMiddleware::class], "update.dashboard2")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Dashboard2Update");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/dashboard2delete[/{id}]", [PermissionMiddleware::class], "delete.dashboard2")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Dashboard2Delete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/dashboard2search", [PermissionMiddleware::class], "search.dashboard2")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Dashboard2Search");
    }
}
