<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CustomizedMessageController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/customizedmessagelist[/{id}]", [PermissionMiddleware::class], "list.customized_message")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomizedMessageList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/customizedmessageadd[/{id}]", [PermissionMiddleware::class], "add.customized_message")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomizedMessageAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/customizedmessageview[/{id}]", [PermissionMiddleware::class], "view.customized_message")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomizedMessageView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/customizedmessagesearch", [PermissionMiddleware::class], "search.customized_message")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CustomizedMessageSearch");
    }
}
