<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CurrencyController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/currencylist[/{id}]", [PermissionMiddleware::class], "list.currency")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/currencyadd[/{id}]", [PermissionMiddleware::class], "add.currency")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/currencyaddopt", [PermissionMiddleware::class], "addopt.currency")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/currencyview[/{id}]", [PermissionMiddleware::class], "view.currency")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/currencyedit[/{id}]", [PermissionMiddleware::class], "edit.currency")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/currencydelete[/{id}]", [PermissionMiddleware::class], "delete.currency")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyDelete");
    }
}
