<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CsvImportController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/csvimportlist[/{id}]", [PermissionMiddleware::class], "list.csv_import")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CsvImportList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/csvimportadd[/{id}]", [PermissionMiddleware::class], "add.csv_import")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CsvImportAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/csvimportview[/{id}]", [PermissionMiddleware::class], "view.csv_import")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CsvImportView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/csvimportedit[/{id}]", [PermissionMiddleware::class], "edit.csv_import")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CsvImportEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/csvimportdelete[/{id}]", [PermissionMiddleware::class], "delete.csv_import")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CsvImportDelete");
    }
}
