<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CostCalculatorDetailedController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/costcalculatordetailedlist[/{id}]", [PermissionMiddleware::class], "list.cost_calculator_detailed")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorDetailedList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/costcalculatordetailededit[/{id}]", [PermissionMiddleware::class], "edit.cost_calculator_detailed")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorDetailedEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/costcalculatordetaileddelete[/{id}]", [PermissionMiddleware::class], "delete.cost_calculator_detailed")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorDetailedDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/costcalculatordetailedsearch", [PermissionMiddleware::class], "search.cost_calculator_detailed")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorDetailedSearch");
    }
}
