<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CostCalculatorController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/costcalculatorlist[/{id}]", [PermissionMiddleware::class], "list.cost_calculator")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/costcalculatoradd[/{id}]", [PermissionMiddleware::class], "add.cost_calculator")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/costcalculatoredit[/{id}]", [PermissionMiddleware::class], "edit.cost_calculator")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/costcalculatordelete[/{id}]", [PermissionMiddleware::class], "delete.cost_calculator")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/costcalculatorsearch", [PermissionMiddleware::class], "search.cost_calculator")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CostCalculatorSearch");
    }
}
