<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CompositionController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/compositionlist[/{id}]", [PermissionMiddleware::class], "list.composition")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CompositionList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/compositionadd[/{id}]", [PermissionMiddleware::class], "add.composition")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CompositionAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/compositionaddopt", [PermissionMiddleware::class], "addopt.composition")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CompositionAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/compositionview[/{id}]", [PermissionMiddleware::class], "view.composition")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CompositionView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/compositionedit[/{id}]", [PermissionMiddleware::class], "edit.composition")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CompositionEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/compositiondelete[/{id}]", [PermissionMiddleware::class], "delete.composition")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CompositionDelete");
    }
}
