<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CollectionLogController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/collectionloglist[/{id}]", [PermissionMiddleware::class], "list.collection_log")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CollectionLogList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/collectionlogview[/{id}]", [PermissionMiddleware::class], "view.collection_log")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CollectionLogView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/collectionlogsearch", [PermissionMiddleware::class], "search.collection_log")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CollectionLogSearch");
    }
}
