<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CodeExchangeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/codeexchangelist[/{id}]", [PermissionMiddleware::class], "list.code_exchange")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CodeExchangeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/codeexchangeadd[/{id}]", [PermissionMiddleware::class], "add.code_exchange")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CodeExchangeAdd");
    }
}
