<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ClientHardwareDataController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/clienthardwaredatalist[/{id}]", [PermissionMiddleware::class], "list.client_hardware_data")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientHardwareDataList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/clienthardwaredataadd[/{id}]", [PermissionMiddleware::class], "add.client_hardware_data")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientHardwareDataAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/clienthardwaredataaddopt", [PermissionMiddleware::class], "addopt.client_hardware_data")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientHardwareDataAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/clienthardwaredataview[/{id}]", [PermissionMiddleware::class], "view.client_hardware_data")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientHardwareDataView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/clienthardwaredataedit[/{id}]", [PermissionMiddleware::class], "edit.client_hardware_data")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientHardwareDataEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/clienthardwaredatadelete[/{id}]", [PermissionMiddleware::class], "delete.client_hardware_data")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientHardwareDataDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/clienthardwaredatasearch", [PermissionMiddleware::class], "search.client_hardware_data")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientHardwareDataSearch");
    }
}
