<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ClientDbController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/clientdblist[/{id}]", [PermissionMiddleware::class], "list.client_db")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientDbList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/clientdbadd[/{id}]", [PermissionMiddleware::class], "add.client_db")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientDbAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/clientdbedit[/{id}]", [PermissionMiddleware::class], "edit.client_db")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientDbEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/clientdbdelete[/{id}]", [PermissionMiddleware::class], "delete.client_db")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientDbDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/clientdbsearch", [PermissionMiddleware::class], "search.client_db")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientDbSearch");
    }
}
