<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ClientCategoryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/clientcategorylist[/{id}]", [PermissionMiddleware::class], "list.client_category")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientCategoryList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/clientcategoryadd[/{id}]", [PermissionMiddleware::class], "add.client_category")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientCategoryAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/clientcategoryaddopt", [PermissionMiddleware::class], "addopt.client_category")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientCategoryAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/clientcategoryview[/{id}]", [PermissionMiddleware::class], "view.client_category")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientCategoryView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/clientcategoryedit[/{id}]", [PermissionMiddleware::class], "edit.client_category")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientCategoryEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/clientcategorydelete[/{id}]", [PermissionMiddleware::class], "delete.client_category")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ClientCategoryDelete");
    }
}
