<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ChaAgentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/chaagentlist[/{id}]", [PermissionMiddleware::class], "list.cha_agent")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ChaAgentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/chaagentadd[/{id}]", [PermissionMiddleware::class], "add.cha_agent")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ChaAgentAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/chaagentaddopt", [PermissionMiddleware::class], "addopt.cha_agent")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ChaAgentAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/chaagentview[/{id}]", [PermissionMiddleware::class], "view.cha_agent")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ChaAgentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/chaagentedit[/{id}]", [PermissionMiddleware::class], "edit.cha_agent")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ChaAgentEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/chaagentdelete[/{id}]", [PermissionMiddleware::class], "delete.cha_agent")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ChaAgentDelete");
    }
}
