<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CarpetSetupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/carpetsetuplist[/{id}]", [PermissionMiddleware::class], "list.carpet_setup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CarpetSetupList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/carpetsetupadd[/{id}]", [PermissionMiddleware::class], "add.carpet_setup")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CarpetSetupAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/carpetsetupview[/{id}]", [PermissionMiddleware::class], "view.carpet_setup")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CarpetSetupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/carpetsetupedit[/{id}]", [PermissionMiddleware::class], "edit.carpet_setup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CarpetSetupEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/carpetsetupdelete[/{id}]", [PermissionMiddleware::class], "delete.carpet_setup")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CarpetSetupDelete");
    }
}
