<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CapacityPlanController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/capacityplanlist[/{id}]", [PermissionMiddleware::class], "list.capacity_plan")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CapacityPlanList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/capacityplanadd[/{id}]", [PermissionMiddleware::class], "add.capacity_plan")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CapacityPlanAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/capacityplanview[/{id}]", [PermissionMiddleware::class], "view.capacity_plan")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CapacityPlanView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/capacityplanedit[/{id}]", [PermissionMiddleware::class], "edit.capacity_plan")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CapacityPlanEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/capacityplandelete[/{id}]", [PermissionMiddleware::class], "delete.capacity_plan")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CapacityPlanDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/capacityplanpreview", [PermissionMiddleware::class], "preview.capacity_plan")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CapacityPlanPreview", null, false);
    }
}
