<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CalendarRoutineTaskController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/calendarroutinetasklist[/{id}]", [PermissionMiddleware::class], "list.calendar_routine_task")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarRoutineTaskList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/calendarroutinetaskadd[/{id}]", [PermissionMiddleware::class], "add.calendar_routine_task")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarRoutineTaskAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/calendarroutinetaskview[/{id}]", [PermissionMiddleware::class], "view.calendar_routine_task")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarRoutineTaskView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/calendarroutinetaskedit[/{id}]", [PermissionMiddleware::class], "edit.calendar_routine_task")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarRoutineTaskEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/calendarroutinetaskdelete[/{id}]", [PermissionMiddleware::class], "delete.calendar_routine_task")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarRoutineTaskDelete");
    }
}
