<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CalendarDeletedController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/calendardeletedlist[/{id}]", [PermissionMiddleware::class], "list.calendar_deleted")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarDeletedList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/calendardeletedadd[/{id}]", [PermissionMiddleware::class], "add.calendar_deleted")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarDeletedAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/calendardeletedview[/{id}]", [PermissionMiddleware::class], "view.calendar_deleted")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarDeletedView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/calendardeletededit[/{id}]", [PermissionMiddleware::class], "edit.calendar_deleted")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarDeletedEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/calendardeleteddelete[/{id}]", [PermissionMiddleware::class], "delete.calendar_deleted")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarDeletedDelete");
    }
}
