<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CalendarController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/calendarlist[/{id}]", [PermissionMiddleware::class], "list.calendar")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/calendaradd[/{id}]", [PermissionMiddleware::class], "add.calendar")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/calendarview[/{id}]", [PermissionMiddleware::class], "view.calendar")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/calendaredit[/{id}]", [PermissionMiddleware::class], "edit.calendar")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/calendardelete[/{id}]", [PermissionMiddleware::class], "delete.calendar")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CalendarDelete");
    }
}
