<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class CChargeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/cchargelist[/{id}]", [PermissionMiddleware::class], "list.c_charge")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CChargeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/cchargeadd[/{id}]", [PermissionMiddleware::class], "add.c_charge")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CChargeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/cchargeview[/{id}]", [PermissionMiddleware::class], "view.c_charge")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CChargeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/cchargeedit[/{id}]", [PermissionMiddleware::class], "edit.c_charge")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CChargeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/cchargedelete[/{id}]", [PermissionMiddleware::class], "delete.c_charge")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CChargeDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/cchargesearch", [PermissionMiddleware::class], "search.c_charge")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CChargeSearch");
    }
}
