<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BuyerSellerViewController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/buyersellerviewlist", [PermissionMiddleware::class], "list.buyer_seller_view")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerSellerViewList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/buyersellerviewadd", [PermissionMiddleware::class], "add.buyer_seller_view")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerSellerViewAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/buyersellerviewaddopt", [PermissionMiddleware::class], "addopt.buyer_seller_view")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerSellerViewAddopt", null, false);
    }
}
