<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BuyerProductRefGController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/buyerproductrefglist[/{id}]", [PermissionMiddleware::class], "list.buyer_product_ref_g")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerProductRefGList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/buyerproductrefgadd[/{id}]", [PermissionMiddleware::class], "add.buyer_product_ref_g")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerProductRefGAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/buyerproductrefgview[/{id}]", [PermissionMiddleware::class], "view.buyer_product_ref_g")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerProductRefGView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/buyerproductrefgedit[/{id}]", [PermissionMiddleware::class], "edit.buyer_product_ref_g")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerProductRefGEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/buyerproductrefgdelete[/{id}]", [PermissionMiddleware::class], "delete.buyer_product_ref_g")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerProductRefGDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/buyerproductrefgsearch", [PermissionMiddleware::class], "search.buyer_product_ref_g")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerProductRefGSearch");
    }
}
