<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BuyerController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/buyerlist[/{id}]", [PermissionMiddleware::class], "list.buyer")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/buyeradd[/{id}]", [PermissionMiddleware::class], "add.buyer")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/buyeraddopt", [PermissionMiddleware::class], "addopt.buyer")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/buyerview[/{id}]", [PermissionMiddleware::class], "view.buyer")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/buyeredit[/{id}]", [PermissionMiddleware::class], "edit.buyer")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/buyerdelete[/{id}]", [PermissionMiddleware::class], "delete.buyer")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/buyersearch", [PermissionMiddleware::class], "search.buyer")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/buyerquery", [PermissionMiddleware::class], "query.buyer")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BuyerSearch", "BuyerQuery");
    }
}
