<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BookingDetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bookingdetailslist", [PermissionMiddleware::class], "list.booking_details")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingDetailsList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bookingdetailssearch", [PermissionMiddleware::class], "search.booking_details")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingDetailsSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/bookingdetailsquery", [PermissionMiddleware::class], "query.booking_details")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingDetailsSearch", "BookingDetailsQuery");
    }
}
