<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BookingConfirmController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bookingconfirmlist[/{id}]", [PermissionMiddleware::class], "list.booking_confirm")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingConfirmList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/bookingconfirmadd[/{id}]", [PermissionMiddleware::class], "add.booking_confirm")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingConfirmAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bookingconfirmview[/{id}]", [PermissionMiddleware::class], "view.booking_confirm")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingConfirmView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bookingconfirmedit[/{id}]", [PermissionMiddleware::class], "edit.booking_confirm")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingConfirmEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/bookingconfirmdelete[/{id}]", [PermissionMiddleware::class], "delete.booking_confirm")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingConfirmDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bookingconfirmsearch", [PermissionMiddleware::class], "search.booking_confirm")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingConfirmSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/bookingconfirmquery", [PermissionMiddleware::class], "query.booking_confirm")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingConfirmSearch", "BookingConfirmQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/bookingconfirmpreview", [PermissionMiddleware::class], "preview.booking_confirm")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BookingConfirmPreview", null, false);
    }
}
