<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BomController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bomlist[/{id}]", [PermissionMiddleware::class], "list.bom")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BomList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/bomadd[/{id}]", [PermissionMiddleware::class], "add.bom")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BomAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bomview[/{id}]", [PermissionMiddleware::class], "view.bom")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BomView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bomedit[/{id}]", [PermissionMiddleware::class], "edit.bom")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BomEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/bomdelete[/{id}]", [PermissionMiddleware::class], "delete.bom")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BomDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bomsearch", [PermissionMiddleware::class], "search.bom")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BomSearch");
    }
}
