<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BlendingTableController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/blendingtablelist[/{id}]", [PermissionMiddleware::class], "list.blending_table")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BlendingTableList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/blendingtableadd[/{id}]", [PermissionMiddleware::class], "add.blending_table")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BlendingTableAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/blendingtableview[/{id}]", [PermissionMiddleware::class], "view.blending_table")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BlendingTableView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/blendingtablesearch", [PermissionMiddleware::class], "search.blending_table")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BlendingTableSearch");
    }
}
