<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BcodeTokenController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bcodetokenlist[/{id}]", [PermissionMiddleware::class], "list.bcode_token")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeTokenList");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bcodetokenedit[/{id}]", [PermissionMiddleware::class], "edit.bcode_token")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeTokenEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/bcodetokenupdate", [PermissionMiddleware::class], "update.bcode_token")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeTokenUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bcodetokensearch", [PermissionMiddleware::class], "search.bcode_token")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeTokenSearch");
    }
}
