<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BcodeSController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bcodeslist[/{id}]", [PermissionMiddleware::class], "list.bcode_s")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeSList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bcodesview[/{id}]", [PermissionMiddleware::class], "view.bcode_s")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeSView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bcodesedit[/{id}]", [PermissionMiddleware::class], "edit.bcode_s")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeSEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bcodessearch", [PermissionMiddleware::class], "search.bcode_s")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeSSearch");
    }
}
