<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BcodeOldController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bcodeoldlist[/{id}]", [PermissionMiddleware::class], "list.bcode_old")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeOldList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bcodeoldview[/{id}]", [PermissionMiddleware::class], "view.bcode_old")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeOldView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bcodeoldsearch", [PermissionMiddleware::class], "search.bcode_old")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeOldSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/bcodeoldquery", [PermissionMiddleware::class], "query.bcode_old")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeOldSearch", "BcodeOldQuery");
    }
}
