<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BcodeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/bcodelist[/{id}]", [PermissionMiddleware::class], "list.bcode")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/bcodeview[/{id}]", [PermissionMiddleware::class], "view.bcode")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/bcodeedit[/{id}]", [PermissionMiddleware::class], "edit.bcode")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/bcodeupdate", [PermissionMiddleware::class], "update.bcode")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/bcodesearch", [PermissionMiddleware::class], "search.bcode")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/bcodequery", [PermissionMiddleware::class], "query.bcode")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BcodeSearch", "BcodeQuery");
    }
}
