<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class BatchNoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/batchnolist[/{id}]", [PermissionMiddleware::class], "list.batch_no")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BatchNoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/batchnoadd[/{id}]", [PermissionMiddleware::class], "add.batch_no")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BatchNoAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/batchnoaddopt", [PermissionMiddleware::class], "addopt.batch_no")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BatchNoAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/batchnoview[/{id}]", [PermissionMiddleware::class], "view.batch_no")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BatchNoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/batchnoedit[/{id}]", [PermissionMiddleware::class], "edit.batch_no")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BatchNoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/batchnodelete[/{id}]", [PermissionMiddleware::class], "delete.batch_no")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BatchNoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/batchnosearch", [PermissionMiddleware::class], "search.batch_no")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BatchNoSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/batchnoquery", [PermissionMiddleware::class], "query.batch_no")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BatchNoSearch", "BatchNoQuery");
    }
}
